package control;

import abstraction.State;

/**
 * @author Balestra Concetta, Hani Qusa
 * @version 1.2 09/04/05
 * @since JDK 1.6
 */


/**
 * Class which contains a couple of states: one target state and one community state
 *
 */
public class SimulatedBy {
	
	private State targetState;
	private CState communityState;
	
	public SimulatedBy() {
		
	}
	
	public SimulatedBy (State ts, CState cs) {
		this.targetState = ts;
		this.communityState = cs;
	}
	
	/**
	 * gets the target state which is present in this pair of states that are in simulation
	 * @return a state of the target service
	 */
	public State getTargetState() {
		return this.targetState;
	}
	
	/**
	 * gets the community state that simulates the target state in this pair
	 * @return a list of states which represent a community state
	 */
	public CState getCommunityState() {
		return this.communityState;
	}

	public boolean equals(Object o) {
    	if (o != null && getClass().equals(o.getClass())) {
    		SimulatedBy other = (SimulatedBy)o;
    		return this.targetState.equals(other.getTargetState()) && this.communityState.equals(other.getCommunityState());
    	}
    	else 
    		return false;
    }
	
	public int hashCode() {
        return (this.targetState.hashCode() + this.communityState.hashCode()); 
    } 
	
	public String toString () {
		String state = new String(this.getTargetState().toString()+ this.communityState.toString());
		return state;
	}
}




